import xml.etree.ElementTree as ET
import numpy as np

# Ruta a tu archivo Info.fcpxml
file_path = "/Users/research/Desktop/5_DATA/2_ASL/XMLS FCPX/1998.fcpxml"  # cámbialo según el archivo

# Parsear el XML
tree = ET.parse(file_path)
root = tree.getroot()

durations = []

# Buscar atributos "duration" en el XML
for elem in root.iter():
    if "duration" in elem.attrib:
        val = elem.attrib["duration"]  # ej: "137/25s" o "46s"
        if val.endswith("s"):
            val = val[:-1]  # quitar la 's'
        # Convertir a frames o segundos
        if "/" in val:
            num, denom = val.split("/")
            seconds = float(num) / float(denom)
        else:
            seconds = float(val)
        durations.append(seconds)

# Pasar a numpy array
durations = np.array(durations)

# Calcular estadísticas
print("Número de shots:", len(durations))
print("Duración promedio (s):", np.mean(durations))
print("Duración máxima (s):", np.max(durations))
print("Duración mínima (s):", np.min(durations))
print("Desviación estándar (s):", np.std(durations))
